<?php
class ControllerExtensionModuleHTMLRM extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('extension/module/html_rm');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('extension/module');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			if (!isset($this->request->get['module_id'])) {
				$this->model_extension_module->addModule('html_rm', $this->request->post);
			} else {
				$this->model_extension_module->editModule($this->request->get['module_id'], $this->request->post);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('extension/extension', 'token=' . $this->session->data['token'] . '&type=module', true));
		}

		//CKEditor
		if ($this->config->get('config_editor_default')) {
			$this->document->addScript('view/javascript/ckeditor/ckeditor.js');
			$this->document->addScript('view/javascript/ckeditor/ckeditor_init.js');
		} else {
			$this->document->addScript('view/javascript/summernote/summernote.js');
			$this->document->addScript('view/javascript/summernote/lang/summernote-' . $this->language->get('lang') . '.js');
			$this->document->addScript('view/javascript/summernote/opencart.js');
			$this->document->addStyle('view/javascript/summernote/summernote.css');
		}
		
		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_edit'] = $this->language->get('text_edit');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		$data['text_yes'] = $this->language->get('text_yes');
		$data['text_no'] = $this->language->get('text_no');
		$data['text_readmore_speed'] = $this->language->get('text_readmore_speed');
		$data['text_name_template'] = $this->language->get('text_name_template');

		$data['entry_name'] = $this->language->get('entry_name');
		$data['entry_title'] = $this->language->get('entry_title');
		$data['entry_description'] = $this->language->get('entry_description');
		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_readmore_height'] = $this->language->get('entry_readmore_height');
		$data['entry_readmore_speed'] = $this->language->get('entry_readmore_speed');
		$data['entry_pixel'] = $this->language->get('entry_pixel');
		$data['entry_milliseconds'] = $this->language->get('entry_milliseconds');
		$data['entry_heading_level'] = $this->language->get('entry_heading_level');
		$data['entry_size_grid'] = $this->language->get('entry_size_grid');
		$data['entry_no_size_grid'] = $this->language->get('entry_no_size_grid');
		$data['entry_size_grid'] = $this->language->get('entry_size_grid');
		$data['entry_name_template'] = $this->language->get('entry_name_template');
		
		$data['entry_version'] = $this->language->get('entry_version');
		$data['entry_support'] = $this->language->get('entry_support');
		$data['entry_author'] = $this->language->get('entry_author');
		$data['entry_documentation'] = $this->language->get('entry_documentation');
		$data['entry_documentation_url'] = $this->language->get('entry_documentation_url');
		
		$data['tab_setting'] = $this->language->get('tab_setting');
		$data['tab_info'] = $this->language->get('tab_info');
		
		$data['help_readmore_height'] = $this->language->get('help_readmore_height');
		$data['help_readmore_speed'] = $this->language->get('help_readmore_speed');
		$data['help_heading_level'] = $this->language->get('help_heading_level');
		$data['help_size_grid'] = $this->language->get('help_size_grid');
		
		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');

		$data['token'] = $this->session->data['token'];
		$data['ckeditor'] = $this->config->get('config_editor_default');

		$data['lang'] = $this->language->get('lang');
		
		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['name'])) {
			$data['error_name'] = $this->error['name'];
		} else {
			$data['error_name'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('extension/extension', 'token=' . $this->session->data['token'] . '&type=module', true)
		);

		if (!isset($this->request->get['module_id'])) {
			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('heading_title'),
				'href' => $this->url->link('extension/module/html_rm', 'token=' . $this->session->data['token'], true)
			);
		} else {
			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('heading_title'),
				'href' => $this->url->link('extension/module/html_rm', 'token=' . $this->session->data['token'] . '&module_id=' . $this->request->get['module_id'], true)
			);
		}

		if (!isset($this->request->get['module_id'])) {
			$data['action'] = $this->url->link('extension/module/html_rm', 'token=' . $this->session->data['token'], true);
		} else {
			$data['action'] = $this->url->link('extension/module/html_rm', 'token=' . $this->session->data['token'] . '&module_id=' . $this->request->get['module_id'], true);
		}

		$data['cancel'] = $this->url->link('extension/extension', 'token=' . $this->session->data['token'], 'SSL');

		if (isset($this->request->get['module_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$module_info = $this->model_extension_module->getModule($this->request->get['module_id']);
		}

		if (isset($this->request->post['name'])) {
			$data['name'] = $this->request->post['name'];
		} elseif (!empty($module_info)) {
			$data['name'] = $module_info['name'];
		} else {
			$data['name'] = '';
		}
		
		if (isset($this->request->post['name_template'])) {
			$data['name_template'] = $this->request->post['name_template'];
		} elseif (!empty($module_info)) {
			$data['name_template'] = $module_info['name_template'];
		} else {
			$data['name_template'] = '';
		}

		if (isset($this->request->post['readmore_height'])) {
			$data['readmore_height'] = $this->request->post['readmore_height'];
		} elseif (!empty($module_info)) {
			$data['readmore_height'] = $module_info['readmore_height'];
		} else {
			$data['readmore_height'] = 100;
		}
		
		if (isset($this->request->post['readmore_speed'])) {
			$data['readmore_speed'] = $this->request->post['readmore_speed'];
		} elseif (!empty($module_info)) {
			$data['readmore_speed'] = $module_info['readmore_speed'];
		} else {
			$data['readmore_speed'] = 500;
		}
		
		/*Size Grid*/
		$data['sizes'] = array('&lt;576', '&lt;768', '&lt;992', '&lt;1200', '&lt;1400', '&gt;=576', '&gt;=768', '&gt;=992', '&gt;=1200', '&gt;=1400');
				
		if (isset($this->request->post['size_grid'])) {
			$data['size_grid'] = $this->request->post['size_grid'];
		} elseif (!empty($module_info['size_grid'])) {
			$data['size_grid'] = $module_info['size_grid'];
		} else {
			$data['size_grid'] = array();
		}
		/*END Size Grid*/
		
		if (isset($this->request->post['heading_level'])) {
			$data['heading_level'] = $this->request->post['heading_level'];
		} elseif (!empty($module_info)) {
			$data['heading_level'] = $module_info['heading_level'];
		} else {
			$data['heading_level'] = 1;
		}
		
		if (isset($this->request->post['module_description'])) {
			$data['module_description'] = $this->request->post['module_description'];
		} elseif (!empty($module_info)) {
			$data['module_description'] = $module_info['module_description'];
		} else {
			$data['module_description'] = array();
		}

		$this->load->model('localisation/language');

		$data['languages'] = $this->model_localisation_language->getLanguages();

		if (isset($this->request->post['status'])) {
			$data['status'] = $this->request->post['status'];
		} elseif (!empty($module_info)) {
			$data['status'] = $module_info['status'];
		} else {
			$data['status'] = '';
		}

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/module/html_rm', $data));
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/module/html_rm')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if ((utf8_strlen($this->request->post['name']) < 3) || (utf8_strlen($this->request->post['name']) > 64)) {
			$this->error['name'] = $this->language->get('error_name');
		}

		return !$this->error;
	}
}