<?php
class ControllerExtensionModuleGalleryrb extends Controller {
	public function index($setting) {
		static $module = 0;

		$this->load->model('tool/image');
    $this->load->model('tool/galleryimage');

		$this->document->addScript('catalog/view/javascript/jquery/magnific/jquery.magnific-popup.min.js');
	  $this->document->addStyle('catalog/view/javascript/jquery/magnific/magnific-popup.css');
    $this->document->addStyle('catalog/view/javascript/jquery/magnific/animation-magnific-popup.css');
    $this->document->addStyle('catalog/view/javascript/jquery/rb-gallery/rb-gallery.css');
    
    if($setting['style'] == 'carousel'){
      $this->document->addScript('catalog/view/javascript/jquery/rb-gallery/rb.owl.carousel.min.js');
    }
    if($setting['style'] == 'masonry'){
      $this->document->addScript('catalog/view/javascript/jquery/rb-gallery/masonry.min.js');
    }

    $data['title'] = (isset($setting['title'])) ? $setting['title'] : $setting['title_gallery'][$this->config->get('config_language_id')];
    $data['description'] = (isset($setting['description'])) ? htmlspecialchars_decode($setting['description'][$this->config->get('config_language_id')],ENT_QUOTES) : '';
    $data['col_lg'] = $setting['col_lg'];
    $data['col_md'] = $setting['col_md'];
    $data['col_sm'] = $setting['col_sm'];
    $data['col_xs'] = $setting['col_xs'];
    $data['style'] = $setting['style'];
    $data['animation'] = $setting['animation'];
    $data['text'] = $setting['text'];
    $data['texthover'] = $setting['texthover'];
    $data['textbg'] = $setting['textbg'];
    if(isset($setting['borderimage'])) $data['borderimage'] = $setting['borderimage'];
    
    // Sort Order for gallery
    if(isset($setting['gallery_image'][$this->config->get('config_language_id')])){
      $results = $setting['gallery_image'][$this->config->get('config_language_id')];
      usort($results, function($a, $b){
        if($a['sort_order'] === $b['sort_order'])
          return 0;  
        return $a['sort_order'] > $b['sort_order'] ? 1 : -1;
      });
    } else {
      $results = array();
    }
    
    if (isset($this->request->get['path']) && isset($setting['categories'])) {
      $parts = explode('_', (string)$this->request->get['path']);
      $category_id = (int)array_pop($parts);    
      if(!(in_array($category_id, $setting['categories']))) {
        $results = array();
      }
    }
    foreach ($results as $result) {
      if (is_file(DIR_IMAGE . $result['image'])) {
        $file_image = getimagesize(DIR_IMAGE . $result['image']);       
        // Popup image resize
        
        $popup_width = $file_image[0];
        $popup_height = $file_image[1];
                      
        $scale = $setting['popup_width'] / $popup_width;
        $new_popup_height = $popup_height * $scale;
        
        if($setting['style'] == 'masonry'){
          $thumb = $this->model_tool_galleryimage->resize($result['image'], $setting['thumb_width'], $setting['thumb_height'], false, 'HA');
        } else {
          $thumb = $this->model_tool_galleryimage->resize($result['image'], $setting['thumb_width'], $setting['thumb_height']);
        }
        
        if($result['link']){
          $link = $result['link'];
          $class = '';
        } else {
          $link = $this->model_tool_image->resize($result['image'], $setting['popup_width'], $new_popup_height);
          $class = 'rb-gallery-popup';
        }
        
        //Fix v2.2
        if(isset($result['image_alt'])){
          $image_alt = $result['image_alt'];
        }else{
          $image_alt = '';
        }
        
        //Fix v2.2
        if(isset($result['image_title'])){
          $image_title = $result['image_title'];
        }else{
          $image_title = '';
        }
        
        $data['galleries'][] = array(
          'description' => htmlspecialchars_decode($result['gallery_image_description'],ENT_QUOTES),
          'link'        => $link,
          'alt'         => $image_alt,
          'title'       => $image_title,
          'class'       => $class,
          'thumb'       => $thumb
        );
      }
    }
    $data['module'] = $module++;
    return $this->load->view('extension/module/galleryrb', $data);
	}
}