<?php
class ControllerExtensionModuleHTMLRM extends Controller {
	public function index($setting) {
		static $module = 0;
		
		$this->load->language('extension/module/html_rm');

		$data['name_template'] = $setting['name_template'];
		$data['text_readmore_hide'] = $this->language->get('text_readmore_hide');
		$data['text_readmore_show'] = $this->language->get('text_readmore_show');
		
		$this->document->addStyle('catalog/view/javascript/jquery/readmore/html_rm.css');
		$this->document->addScript('catalog/view/javascript/jquery/readmore/readmore.min.js');
		
		$data['readmore_speed'] = $setting['readmore_speed'] ? $setting['readmore_speed'] : '500';
		$data['readmore_height'] = $setting['readmore_height'] ? $setting['readmore_height'] : '200';
		
		$data['heading_level'] = $setting['heading_level'] ? $setting['heading_level'] : 'h1';
		
		if (isset($setting['size_grid'])){
			$size_grids = $setting['size_grid'] ;
	
			foreach ($size_grids as $key => $value) {
				$data['size_grids'][] = array(
					'size'     => htmlspecialchars_decode($value)
				);
			}
		}
		
		if (isset($setting['module_description'][$this->config->get('config_language_id')])) {
			$data['heading_title'] = html_entity_decode($setting['module_description'][$this->config->get('config_language_id')]['title'], ENT_QUOTES, 'UTF-8');
			$data['html_rm'] = html_entity_decode($setting['module_description'][$this->config->get('config_language_id')]['description'], ENT_QUOTES, 'UTF-8');	
		}
		
		$data['module'] = $module++;
		
		if (!empty($setting['name_template'])){
			return $this->load->view('extension/module/html_rm/'.$setting['name_template'].'.tpl', $data);		
		}else{
			return $this->load->view('extension/module/html_rm', $data);
		}
	}
}