<?php
class ModelToolImage extends Model {
	public function resize($filename, $width, $height) {
		if (!is_file(DIR_IMAGE . $filename) || substr(str_replace('\\', '/', realpath(DIR_IMAGE . $filename)), 0, strlen(DIR_IMAGE)) != DIR_IMAGE) {
			return;
		}

		$extension = pathinfo($filename, PATHINFO_EXTENSION);

		$image_old = $filename;

        if (defined('DISABLE_WEBP')) {
          $isWebpConverterEnabled = false;
        } else {
          $isWebpConverterEnabled = $this->config->get('webp_image_status') ? true : false;
        }
        
        if ($extension == 'gif') {
          $this->load->model('tool/webp_image');
          if ($this->model_tool_webp_image->isAnimatedGif(DIR_IMAGE . $filename)) {
             $isWebpConverterEnabled = false;
          }
        }
        
        if ((isset($_SERVER['HTTP_ACCEPT']) && strpos($_SERVER['HTTP_ACCEPT'], 'image/webp') === false) || (isset($_SERVER['HTTP_USER_AGENT']) && strpos($_SERVER['HTTP_USER_AGENT'], 'Safari') && !strpos($_SERVER['HTTP_USER_AGENT'], 'Chrome'))) {
          $isWebpConverterEnabled = false;
        }
        
        if ($isWebpConverterEnabled) {
          if (!function_exists('imagewebp')) {
            error_log('GD Extension is not enabled or not recent enough, not possible to create webp image');
            $isWebpConverterEnabled = false;
          }
          
          // compatibility with journal image compress
          if (defined('JOURNAL3_ACTIVE')) {
            $this->journal3->settings->set('performanceCompressImagesStatus', false);
          }
          
          $webpImageQuality = $this->config->get('webp_image_quality') ? $this->config->get('webp_image_quality') : 92;
        
          $extension = 'webp';
        }
      
		$image_new = 'cache/' . utf8_substr($filename, 0, utf8_strrpos($filename, '.')) . '-' . (int)$width . 'x' . (int)$height . '.' . $extension;

		if (!is_file(DIR_IMAGE . $image_new) || (filectime(DIR_IMAGE . $image_old) > filectime(DIR_IMAGE . $image_new))) {
			list($width_orig, $height_orig, $image_type) = getimagesize(DIR_IMAGE . $image_old);
				 
			if (!in_array($image_type, array(IMAGETYPE_PNG, IMAGETYPE_JPEG, IMAGETYPE_GIF))) { 
				return DIR_IMAGE . $image_old;
			}
						
			$path = '';

			$directories = explode('/', dirname($image_new));

			foreach ($directories as $directory) {
				$path = $path . '/' . $directory;

				if (!is_dir(DIR_IMAGE . $path)) {
					@mkdir(DIR_IMAGE . $path, 0777);
				}
			}

			if ($width_orig != $width || $height_orig != $height) {
				$image = new Image(DIR_IMAGE . $image_old);
				$image->resize($width, $height);
				
      if (isset($webpImageQuality)) {
        ${'image'}->save(DIR_IMAGE . $image_new, $webpImageQuality);
      } else {
        $image->save(DIR_IMAGE . $image_new);
      }
      
			} else {
				
      if ($isWebpConverterEnabled) {
        $image = new Image(DIR_IMAGE . $image_old);
        ${'image'}->save(DIR_IMAGE . $image_new, $webpImageQuality);
      } else {
        copy(DIR_IMAGE . $image_old, DIR_IMAGE . $image_new);
      }
      
			}
		}
		
		$image_new = str_replace(' ', '%20', $image_new);  // fix bug when attach image on email (gmail.com). it is automatic changing space " " to +
		
		if ($this->request->server['HTTPS']) {
			return $this->config->get('config_ssl') . 'image/' . $image_new;
		} else {
			return $this->config->get('config_url') . 'image/' . $image_new;
		}
	}
}
