<!DOCTYPE html>
<!--[if IE]><![endif]-->
<!--[if IE 8 ]><html dir="<?php echo $direction; ?>" lang="<?php echo $lang; ?>" class="ie8"><![endif]-->
<!--[if IE 9 ]><html dir="<?php echo $direction; ?>" lang="<?php echo $lang; ?>" class="ie9"><![endif]-->
<!--[if (gt IE 9)|!(IE)]><!-->
<html dir="<?php echo $direction; ?>" lang="<?php echo $lang; ?>">
<!--<![endif]-->
<head prefix="og:http://ogp.me/ns# fb:http://ogp.me/ns/fb# product:http://ogp.me/ns/product#">
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<title><?php echo $title; ?></title>
<base href="<?php echo $base; ?>" />
<?php if ($robots) { ?><meta name="robots" content="<?php echo $robots; ?>" />
			<?php } ?>
<?php if ($description) { ?><meta name="description" content="<?php echo $description; ?>" /><?php } ?>
<?php if ($keywords) { ?><meta name="keywords" content= "<?php echo $keywords; ?>" /><?php } ?>
<!-- Load essential resources -->
<script src="catalog/view/javascript/jquery/jquery-2.1.1.min.js"></script>
<script src="catalog/view/javascript/jquery/jquery-2.1.1.min.js" type="text/javascript"></script>
<link href="catalog/view/javascript/bootstrap/css/bootstrap.min.css" rel="stylesheet" media="screen" />
<script src="catalog/view/javascript/bootstrap/js/bootstrap.min.js"></script>
<script src="catalog/view/theme/basel/js/slick.min.js"></script>
<script src="catalog/view/theme/basel/js/basel_common.js"></script>
<!-- Main stylesheet -->
<link href="catalog/view/theme/basel/stylesheet/stylesheet.css" rel="stylesheet">
<link href="catalog/view/theme/basel/stylesheet/hover.css" rel="stylesheet">
<!-- Mandatory Theme Settings CSS -->
<style id="basel-mandatory-css"><?php echo $basel_mandatory_css; ?></style>
<!-- Plugin Stylesheet(s) -->
<?php foreach ($styles as $style) { ?>
<link href="<?php echo $style['href']; ?>" rel="<?php echo $style['rel']; ?>" media="<?php echo $style['media']; ?>" />
<?php } ?>
<!-- Pluing scripts(s) -->
<?php if (!empty($mlseo_fix_search)) { ?><script type="text/javascript">$(document).ready(function() { $('#header input[name=\'search\']').unbind('keydown'); $('.button-search').unbind('click'); $('#header input[name=\'search\']').on('keydown', function(e){ if (e.keyCode == 13) {$('.button-search').click();}}); $('.button-search').on('click', function() { var url = '<?php echo isset($csp_search_url) ? $csp_search_url : "$('base').attr('href') + 'index.php?route=product/search"; ?>'; var value = $('input[name=\'search\']').attr('value'); if (value) {if (url.indexOf('?') > -1) {url += '&search=' + encodeURIComponent(value);} else {url += '?search=' + encodeURIComponent(value);}} location = url; });});</script><?php } ?>
<?php foreach ($scripts as $script) { ?>
<script src="<?php echo $script; ?>"></script>
<?php } ?>
<!-- Page specific meta information -->

<?php if (!empty($mlseo_meta)) { echo $mlseo_meta; } ?>
      
<?php foreach ($links as $link) { ?>
<?php if ($link['rel'] == 'image') { ?>
<meta property="og:image" content="<?php echo $link['href']; ?>" />
<?php } else { ?>
<link href="<?php echo $link['href']; ?>" rel="<?php echo $link['rel']; ?>" />
<?php } ?>
<?php } ?>
<!-- Analytic tools -->
<?php foreach ($analytics as $analytic) { ?>
<?php echo $analytic; ?>
<?php } ?>
<?php if (isset($basel_styles_status)) { ?>
<!-- Custom Color Scheme -->
<style id="basel-color-scheme"><?php echo $basel_styles_cache; ?></style>
<?php } ?>
<?php if (isset($basel_typo_status)) { ?>
<!-- Custom Fonts -->
<style id="basel-fonts"><?php echo $basel_fonts_cache; ?></style>
<?php } ?>
<?php if ($direction == 'rtl') { ?>
<link href="catalog/view/theme/basel/stylesheet/rtl.css" rel="stylesheet">
<?php } ?>
<?php if ($basel_custom_css_status) { ?>
<!-- Custom CSS -->
<style id="basel-custom-css">
<?php echo $basel_custom_css; ?>
</style>
<?php } ?>
<?php if ($basel_custom_js_status) { ?>
<!-- Custom Javascript -->
<script>
<?php echo $basel_custom_js; ?>
</script>
<?php } ?>

				<?php if (isset($agreedata) && $agreedata['status'] != 0) { ?>
				<link href="catalog/view/theme/basel/stylesheet/agree_popup/style_agree.css" rel="stylesheet">
				<script src="catalog/view/javascript/popup.js" type="text/javascript"></script>
				<script type="text/javascript">
				$(function() {
				<?php $delay_time = isset($agreedata['delay_time']) ? $agreedata['delay_time'] : '1000'; ?>
					<?php if($agreedata['method_agree_popup']=='method_session') { ?>
						if(sessionStorage['PopupAgree'] != 'yes'){ 
							setTimeout(function(){
								ShowAgree();
							}, <?php echo $delay_time; ?>);
						}
					<?php } else { ?>
						<?php if (!isset($_COOKIE['PopupAgree'])) { ?>
							setTimeout(function(){
								ShowAgree();
							}, <?php echo $delay_time; ?>);
						<?php } ?>
					<?php } ?>
				});
				var loading_masked_img = '<img src="catalog/view/theme/default/image/ring-alt-1.svg" />';
				function loading_agree(action) {
					if (action) {
						$('#loading_agree').html(loading_masked_img);
						$('#loading_agree').show();
					} else {
						$('#loading_agree').html('');
						$('#loading_agree').hide();
					}
				}
				function ShowAgree() {
					$('body').prepend('<div id="loading_agree"></div>');
					loading_agree(true); 
					$('body').append('<div class="popup_agree"></div>');
					$('.popup_agree').popup({
						transition: 'all 0.3s',
						escape: <?php if($agreedata['escape_click']=='1') { ?> true <?php } else { ?> false <?php } ?>,
						blur: <?php if($agreedata['blur_click']=='1') { ?> true <?php } else { ?> false <?php } ?>,
						closetransitionend: function () {$(this).remove();}
					});
					$('.popup_agree').load('index.php?route=extension/module/agree_popup', function() {
						loading_agree(false); 
						$('.popup_agree').popup('show');
					});
				}
				</script>
				<?php } ?>
			
</head>
<body class="<?php echo $class; ?><?php echo $basel_body_class; ?>">
<?php require_once('catalog/view/theme/basel/template/common/mobile-nav.tpl'); ?>
<div class="outer-container main-wrapper">
<?php if ($notification_status) { ?>
<div class="top_notificaiton">
  <div class="container<?php if ($top_promo_close) echo ' has-close'; ?> <?php echo $top_promo_width; ?> <?php echo $top_promo_align; ?>">
    <div class="table">
    <div class="table-cell w100"><div class="ellipsis-wrap"><?php echo $top_promo_text; ?></div></div>
    <?php if ($top_promo_close) { ?>
    <div class="table-cell text-right">
    <a onClick="addCookie('basel_top_promo', 1, 30);$(this).closest('.top_notificaiton').slideUp();" class="top_promo_close">&times;</a>
    </div>
    <?php } ?>
    </div>
  </div>
</div>
<?php } ?>
<?php require_once('catalog/view/theme/basel/template/common/headers/' . $basel_header . '.tpl'); ?>
<!-- breadcrumb -->
<div class="breadcrumb-holder">
<div class="container">
<span id="title-holder">&nbsp;</span>
<div class="links-holder">
<a class="basel-back-btn" onClick="history.go(-1); return false;"><i></i></a><span>&nbsp;</span>
</div>
</div>
</div>
<div class="container">
<?php echo $position_top; ?>
</div>