<?php
final class Front {
	private $registry;
	private $pre_action = array();
	private $error;

	public function __construct($registry) {
		$this->registry = $registry;
	}
	
	public function addPreAction(Action $pre_action) {
		$this->pre_action[] = $pre_action;
	}
	
	public function dispatch(Action $action, Action $error) {
		$this->error = $error;

		foreach ($this->pre_action as $pre_action) {
			/* BuslikDrev edition cache */
			if (!defined('DIR_CATALOG') && (version_compare(VERSION, '2.2.0', '>') ? $pre_action->getId() == 'startup/maintenance' : $pre_action->getBusId() == 'common/maintenance')) {
				if (!(php_sapi_name() === 'cli')) {
					$ЖЫДКЭШ = new Bus_Cache\Bus_Cache($this->registry, microtime(true));
				}
			}
			/* BuslikDrev edition cache */
			$result = $this->execute($pre_action);

			if ($result instanceof Action) {
				$action = $result;

				break;
			}
		}

		while ($action instanceof Action) {
			$action = $this->execute($action);
		}
	}

	private function execute(Action $action) {
		$result = $action->execute($this->registry);

		if ($result instanceof Action) {
			return $result;
		} 
		
		if ($result instanceof Exception) {
			$action = $this->error;
			
			$this->error = null;
			
			return $action;
		}
	}
}
